<?php
/*
Plugin Name: Blogus Mobile Wx-Style Menu
Plugin URI: https://yourwebsite.com/
Description: V1.6 
Version: 1.6
Author: byxw
Text Domain: wx-mini-menu
*/

if ( ! defined( 'ABSPATH' ) ) { exit; }

class Wx_Style_Mobile_Menu_V2 {

    public function __construct() {
        add_action( 'admin_menu', array( $this, 'add_admin_menu' ) );
        add_action( 'admin_init', array( $this, 'register_settings' ) );
        add_action( 'admin_enqueue_scripts', array( $this, 'admin_scripts' ) );
        add_filter( 'plugin_action_links_' . plugin_basename(__FILE__), array( $this, 'add_plugin_settings_link' ) );
        add_action( 'wp_footer', array( $this, 'output_menu' ) );
    }

    // 插件列表添加设置链接
    public function add_plugin_settings_link( $links ) {
        $url = admin_url( 'admin.php?page=wx-mini-menu' );
        $links[] = '<a href="' . esc_url( $url ) . '">设置</a>';
        return $links;
    }

    // 后台菜单
    public function add_admin_menu() {
        add_menu_page( '微信风格菜单设置', '微信底部菜单', 'manage_options', 'wx-mini-menu', array( $this, 'render_admin_page' ), 'dashicons-smartphone', 59 );
    }

    // 媒体上传器
    public function admin_scripts( $hook ) {
        if ( 'toplevel_page_wx-mini-menu' !== $hook ) { return; }
        wp_enqueue_media();
        wp_add_inline_script( 'jquery-core', "
            jQuery(document).ready(function($) {
                $('#wx_upload_qr_btn').click(function(e) {
                    e.preventDefault();
                    var uploader = wp.media({ title: '选择二维码', button: { text: '使用' }, multiple: false });
                    uploader.on('select', function() {
                        var attachment = uploader.state().get('selection').first().toJSON();
                        $('#wx_qrcode_url').val(attachment.url);
                        $('.wx-preview-img').attr('src', attachment.url).show();
                    });
                    uploader.open();
                });
            });"
        );
    }

    // 注册设置
    public function register_settings() {
        for ( $i = 1; $i <= 4; $i++ ) {
            register_setting( 'wx_menu_group', 'wx_menu_title_' . $i, 'sanitize_text_field' );
            register_setting( 'wx_menu_group', 'wx_menu_link_' . $i, 'esc_url_raw' );
            register_setting( 'wx_menu_group', 'wx_menu_order_' . $i, 'absint' );
        }
        register_setting( 'wx_menu_group', 'wx_color_default', 'sanitize_hex_color' );
        register_setting( 'wx_menu_group', 'wx_color_active',  'sanitize_hex_color' );
        register_setting( 'wx_menu_group', 'wx_color_bg',      'sanitize_hex_color' );
        register_setting( 'wx_menu_group', 'wx_search_item_index', 'absint' ); 
        register_setting( 'wx_menu_group', 'wx_qrcode_item_index', 'absint' ); 
        register_setting( 'wx_menu_group', 'wx_enable_padding', 'absint' ); 
        register_setting( 'wx_menu_group', 'wx_qrcode_url', 'esc_url_raw' );
    }

    // 排序回调函数
    public function sort_items_callback( $a, $b ) {
        if ( $a['order'] == $b['order'] ) { return 0; }
        return ( $a['order'] < $b['order'] ) ? -1 : 1;
    }

    // 后台页面
    public function render_admin_page() {
        ?>
        <div class="wrap"><h1>微信风格移动端菜单设置 <small style="font-size:0.5em;color:#666;">V1.6</small></h1>
        <form method="post" action="options.php"><?php settings_fields( 'wx_menu_group' ); ?>
        
        <h2>1. 菜单配置 (可排序)</h2><table class="form-table">
        <?php for ( $i = 1; $i <= 4; $i++ ): 
            $title = get_option( 'wx_menu_title_' . $i, "" );
            $link  = get_option( 'wx_menu_link_' . $i, "" );
            $order = get_option( 'wx_menu_order_' . $i, $i );
        ?>
            <tr><th colspan="2"><hr style="border:0;border-top:1px solid #eee;"><h3>菜单项 <?php echo $i; ?></h3></th></tr>
            <tr><th>排序</th><td><input type="number" name="wx_menu_order_<?php echo $i; ?>" value="<?php echo esc_attr( $order ); ?>" class="small-text"> <span class="description">数字越小越靠左</span></td></tr>
            <tr><th>名称</th><td><input type="text" name="wx_menu_title_<?php echo $i; ?>" value="<?php echo esc_attr( $title ); ?>" class="regular-text"></td></tr>
            <tr><th>链接</th><td><input type="text" name="wx_menu_link_<?php echo $i; ?>" value="<?php echo esc_attr( $link ); ?>" class="regular-text code"></td></tr>
        <?php endfor; ?>
        </table>

        <h2>2. 公众号二维码</h2><table class="form-table">
            <tr><th>上传</th><td>
                <input type="text" name="wx_qrcode_url" id="wx_qrcode_url" value="<?php echo esc_url( get_option('wx_qrcode_url', '') ); ?>" class="regular-text" style="width:60%">
                <button type="button" id="wx_upload_qr_btn" class="button">选择图片</button>
                <?php if( get_option('wx_qrcode_url') ): ?><img src="<?php echo esc_url( get_option('wx_qrcode_url') ); ?>" class="wx-preview-img" style="max-width:150px;border:1px solid #ccc;margin-top:10px;"><?php endif; ?>
            </td></tr>
            <tr><th>触发</th><td>
                <select name="wx_qrcode_item_index">
                    <?php for($j=0;$j<=4;$j++): ?><option value="<?php echo $j ?>" <?php selected( get_option('wx_qrcode_item_index', 0), $j ); ?>><?php echo $j==0?'不使用':'菜单项 '.$j; ?></option><?php endfor; ?>
                </select>
            </td></tr>
        </table>

        <h2>3. 搜索与外观</h2><table class="form-table">
            <tr><th>搜索</th><td>
                <select name="wx_search_item_index">
                    <?php for($j=0;$j<=4;$j++): ?><option value="<?php echo $j ?>" <?php selected( get_option('wx_search_item_index', 0), $j ); ?>><?php echo $j==0?'不使用':'菜单项 '.$j; ?></option><?php endfor; ?>
                </select>
            </td></tr>
            <tr><th>防遮挡</th><td><label><input type="checkbox" name="wx_enable_padding" value="1" <?php checked( get_option( 'wx_enable_padding', 1 ), 1 ); ?>> 开启</label></td></tr>
            <tr><th>颜色</th><td>
                默认: <input type="color" name="wx_color_default" value="<?php echo esc_attr( get_option('wx_color_default', '#999999') ); ?>">
                选中: <input type="color" name="wx_color_active" value="<?php echo esc_attr( get_option('wx_color_active', '#07c160') ); ?>">
                背景: <input type="color" name="wx_color_bg" value="<?php echo esc_attr( get_option('wx_color_bg', '#ffffff') ); ?>">
            </td></tr>
        </table>

        <?php submit_button(); ?></form></div><?php
    }

    // 前端输出
    public function output_menu() {
        $raw_items = array();
        for ( $i = 1; $i <= 4; $i++ ) {
            $raw_items[ $i ] = array(
                'index' => $i,
                'title' => get_option( 'wx_menu_title_' . $i, "" ),
                'link'  => get_option( 'wx_menu_link_' . $i, "" ),
                'order' => get_option( 'wx_menu_order_' . $i, $i ),
                'icon'  => $this->get_icon_svg( $i )
            );
        }

        $color_default = get_option( 'wx_color_default', '#999999' );
        $color_active  = get_option( 'wx_color_active', '#07c160' );
        $color_bg      = get_option( 'wx_color_bg', '#ffffff' );
        $search_index  = get_option( 'wx_search_item_index', 0 );
        $qrcode_index  = get_option( 'wx_qrcode_item_index', 0 );
        $qrcode_url    = get_option( 'wx_qrcode_url', '' );
        $enable_padding = get_option( 'wx_enable_padding', 1 );

        uasort( $raw_items, array( $this, 'sort_items_callback' ) );

        $items = array();
        $current_url = rtrim( home_url( add_query_arg( array(), $GLOBALS['wp']->request ) ), '/' );

        foreach ( $raw_items as $item ) {
            if ( ! empty( $item['title'] ) ) {
                $is_search = ( $item['index'] == $search_index );
                $is_qrcode = ( $item['index'] == $qrcode_index );
                $link      = '#';
                $class     = 'wx-mini-item';
                if( (rtrim($item['link'],'/') === $current_url) || ($item['link']==='#' && is_front_page()) ) $class .= ' active';
                
                if ( $is_search ) { $class .= ' wx-search-trigger'; } 
                elseif ( $is_qrcode ) { $class .= ' wx-qrcode-trigger'; } 
                else { $link = esc_url( $item['link'] ); }

                $items[] = '<a href="'.$link.'" class="'.$class.'"><div class="wx-icon">'.$item['icon'].'</div><span class="wx-text">'.esc_html($item['title']).'</span></a>';
            }
        }
        if ( empty( $items ) ) return;

        echo '<div class="wx-mini-bar">'.implode('', $items).'</div>';
        
        // 搜索遮罩
        echo '<div id="wx-search-overlay" class="wx-search-overlay" style="display:none;">
            <div class="wx-search-header">
                <form role="search" method="get" class="wx-search-form" action="'.home_url('/').'">
                    <input type="search" class="wx-search-input" placeholder="搜索..." value="'.esc_attr(get_search_query()).'" name="s">
                    <button type="submit" class="wx-search-submit">搜索</button>
                </form><button class="wx-search-close">取消</button>
            </div></div>';

        // 二维码遮罩
        if( $qrcode_url ) {
            echo '<div id="wx-qrcode-overlay" class="wx-qrcode-overlay" style="display:none;">
                <div class="wx-qrcode-content">
                    <div class="wx-qrcode-close">✕</div>
                    <img src="'.esc_url($qrcode_url).'" class="wx-qrcode-img">
                    <p class="wx-qrcode-tip">也可以在微信查找“分享巴中”</p>
                </div></div>';
        }

        // CSS & JS
        echo "<style>:root{--wx-c-default:".esc_attr($color_default).";--wx-c-active:".esc_attr($color_active).";--wx-c-bg:".esc_attr($color_bg).";}
        @media(min-width:769px){.wx-mini-bar,.wx-search-overlay,.wx-qrcode-overlay{display:none!important}}
        @media(max-width:768px){".($enable_padding?"html{padding-bottom:60px}":"").".wx-mini-bar{position:fixed;bottom:0;left:0;width:100%;height:60px;background:var(--wx-c-bg);border-top:1px solid rgba(0,0,0,0.1);display:flex;justify-content:space-around;align-items:center;z-index:99999;-webkit-tap-highlight-color:transparent}
        .wx-mini-item{display:flex;flex-direction:column;align-items:center;justify-content:center;text-decoration:none;color:var(--wx-c-default);flex:1;height:100%}.wx-mini-item.active{color:var(--wx-c-active)}.wx-icon{width:24px;height:24px;margin-bottom:2px;fill:currentColor}.wx-text{font-size:12px;line-height:1.2;font-weight:500;white-space:nowrap}
        .wx-search-overlay,.wx-qrcode-overlay{position:fixed;top:0;left:0;width:100%;height:100%;z-index:99998;display:none;align-items:center;justify-content:center}.wx-search-overlay{background:rgba(255,255,255,0.98);padding-top:100px;flex-direction:column}.wx-search-header{width:90%;display:flex;flex-direction:column;gap:15px}.wx-search-form{display:flex;gap:10px}.wx-search-input{flex:1;padding:12px;border:1px solid #ddd}.wx-search-submit{padding:0 20px;background:var(--wx-c-active);color:#fff;border:none}.wx-search-close{background:none;border:none;color:#666}
        .wx-qrcode-overlay{background:rgba(0,0,0,0.6)}.wx-qrcode-content{position:relative;background:#fff;padding:20px;border-radius:8px;text-align:center;width:80%;max-width:300px}.wx-qrcode-close{position:absolute;top:-15px;right:-10px;width:30px;height:30px;background:#333;color:#fff;border-radius:50%;text-align:center;line-height:30px;cursor:pointer}.wx-qrcode-img{width:100%;height:auto}.wx-qrcode-tip{margin-top:10px;font-size:14px;color:#666}}</style>";

        echo "<script>document.addEventListener('DOMContentLoaded',function(){
            var sTrig=document.querySelector('.wx-search-trigger'),sOver=document.getElementById('wx-search-overlay'),sClose=document.querySelector('.wx-search-close');
            if(sTrig)sTrig.onclick=function(e){e.preventDefault();sOver.style.display='flex';sOver.querySelector('input').focus();};
            if(sClose)sClose.onclick=function(){sOver.style.display='none';};
            var qTrig=document.querySelector('.wx-qrcode-trigger'),qOver=document.getElementById('wx-qrcode-overlay'),qClose=document.querySelector('.wx-qrcode-close');
            if(qTrig)qTrig.onclick=function(e){e.preventDefault();qOver.style.display='flex';};
            if(qClose)qClose.onclick=function(){qOver.style.display='none';};
        });</script>";
    }

    private function get_icon_svg( $index ) {
        $icons = array(
            1 => '<svg viewBox="0 0 24 24"><path d="M10 20v-6h4v6h5v-8h3L12 3 2 12h3v8z"/></svg>',
            2 => '<svg viewBox="0 0 24 24"><path d="M3 18h18v-2H3v2zm0-5h18v-2H3v2zm0-7v2h18V6H3z"/></svg>', // 汉堡菜单 (导航)
            3 => '<svg viewBox="0 0 24 24"><path d="M15.5 14h-.79l-.28-.27C15.41 12.59 16 11.11 16 9.5 16 5.91 13.09 3 9.5 3S3 5.91 3 9.5 5.91 16 9.5 16c1.61 0 3.09-.59 4.23-1.57l.27.28v.79l5 4.99L20.49 19l-4.99-5zm-6 0C7.01 14 5 11.99 5 9.5S7.01 5 9.5 5 14 7.01 14 9.5 11.99 14 9.5 14z"/></svg>',
            4 => '<svg viewBox="0 0 24 24"><path d="M12 12c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4zm0 2c-2.67 0-8 1.34-8 4v2h16v-2c0-2.66-5.33-4-8-4z"/></svg>'
        );
        return isset( $icons[ $index ] ) ? $icons[ $index ] : $icons[1];
    }
}

new Wx_Style_Mobile_Menu_V2();
